@extends('layouts.app')

@section('title', 'Edit Doctor')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h1 class="text-3xl font-bold text-gray-800">Edit Doctor: {{ $doctor->full_name }}</h1>
        <div class="flex gap-2">
            <a href="{{ route('admin.doctors.show', $doctor->id) }}" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Back to Doctor
            </a>
            <a href="{{ route('admin.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
                <i class="fas fa-home mr-2"></i>Dashboard
            </a>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.doctors.update', $doctor->id) }}" enctype="multipart/form-data" class="bg-white rounded-lg shadow p-6">
        @csrf
        @method('PUT')

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Personal Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Title</label>
                    <input type="text" name="title" value="{{ old('title', $doctor->title) }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">First Name *</label>
                    <input type="text" name="first_name" value="{{ old('first_name', $doctor->first_name) }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Last Name *</label>
                    <input type="text" name="last_name" value="{{ old('last_name', $doctor->last_name) }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Email *</label>
                    <input type="email" name="email" value="{{ old('email', $doctor->email) }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Phone</label>
                    <input type="text" name="phone" value="{{ old('phone', $doctor->phone) }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Country</label>
                    <input type="text" name="country" value="{{ old('country', $doctor->country) }}" class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Professional Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Practice Number *</label>
                    <input type="text" name="practice_number" value="{{ old('practice_number', $doctor->practice_number) }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Specialization</label>
                    <input type="text" name="specialization" value="{{ old('specialization', $doctor->specialization) }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Qualification</label>
                    <input type="text" name="qualification" value="{{ old('qualification', $doctor->qualification) }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div class="md:col-span-2">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Educational Details</label>
                    <textarea name="educational_details" rows="3" class="w-full px-3 py-2 border rounded">{{ old('educational_details', $doctor->educational_details) }}</textarea>
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Account Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Password (leave blank to keep current)</label>
                    <input type="password" name="password" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Confirm Password</label>
                    <input type="password" name="password_confirmation" class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Status</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="is_verified" value="1" {{ old('is_verified', $doctor->is_verified) ? 'checked' : '' }} class="mr-2">
                        <span class="text-gray-700 text-sm font-bold">Verified</span>
                    </label>
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $doctor->is_active) ? 'checked' : '' }} class="mr-2">
                        <span class="text-gray-700 text-sm font-bold">Active</span>
                    </label>
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Upload Documents</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Profile Picture</label>
                    @if($doctor->profile_picture_path)
                        <div class="mb-2">
                            <img src="{{ asset('storage/' . $doctor->profile_picture_path) }}" alt="Current Profile Picture" class="h-20 w-20 rounded object-cover">
                        </div>
                    @endif
                    <input type="file" name="profile_picture" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB (leave blank to keep current)</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Letterhead</label>
                    @if($doctor->letterhead_path)
                        <div class="mb-2">
                            <img src="{{ asset('storage/' . $doctor->letterhead_path) }}" alt="Current Letterhead" class="h-20 w-20 rounded object-cover">
                        </div>
                    @endif
                    <input type="file" name="letterhead" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB (leave blank to keep current)</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Stamp</label>
                    @if($doctor->stamp_path)
                        <div class="mb-2">
                            <img src="{{ asset('storage/' . $doctor->stamp_path) }}" alt="Current Stamp" class="h-20 w-20 rounded object-cover">
                        </div>
                    @endif
                    <input type="file" name="stamp" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB (leave blank to keep current)</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Signature</label>
                    @if($doctor->signature_path)
                        <div class="mb-2">
                            <img src="{{ asset('storage/' . $doctor->signature_path) }}" alt="Current Signature" class="h-20 w-20 rounded object-cover">
                        </div>
                    @endif
                    <input type="file" name="signature" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB (leave blank to keep current)</p>
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded">
                Update Doctor
            </button>
        </div>
    </form>
</div>
@endsection

